package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessEndpointResponse(
    verifiedAccessEndpoint: Optional[zio.aws.ec2.model.VerifiedAccessEndpoint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse = {
    import CreateVerifiedAccessEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse
      .builder()
      .optionallyWith(
        verifiedAccessEndpoint.map(value => value.buildAwsValue())
      )(_.verifiedAccessEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessEndpointResponse.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessEndpointResponse.wrap(buildAwsValue())
}
object CreateVerifiedAccessEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessEndpointResponse =
      zio.aws.ec2.model.CreateVerifiedAccessEndpointResponse(
        verifiedAccessEndpoint.map(value => value.asEditable)
      )
    def verifiedAccessEndpoint
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly]
    def getVerifiedAccessEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessEndpoint",
      verifiedAccessEndpoint
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse
  ) extends zio.aws.ec2.model.CreateVerifiedAccessEndpointResponse.ReadOnly {
    override val verifiedAccessEndpoint
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessEndpoint())
        .map(value => zio.aws.ec2.model.VerifiedAccessEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse
  ): zio.aws.ec2.model.CreateVerifiedAccessEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
