package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionIdWithResolver
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptVpcPeeringConnectionRequest(
    vpcPeeringConnectionId: Optional[VpcPeeringConnectionIdWithResolver] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest = {
    import AcceptVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
      .builder()
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          VpcPeeringConnectionIdWithResolver.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object AcceptVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest =
      zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest(
        vpcPeeringConnectionId.map(value => value)
      )
    def vpcPeeringConnectionId: Optional[VpcPeeringConnectionIdWithResolver]
    def getVpcPeeringConnectionId
        : ZIO[Any, AwsError, VpcPeeringConnectionIdWithResolver] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly {
    override val vpcPeeringConnectionId
        : Optional[VpcPeeringConnectionIdWithResolver] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcPeeringConnectionId())
      .map(value =>
        zio.aws.ec2.model.primitives.VpcPeeringConnectionIdWithResolver(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
