package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpnState {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpnState
}
object VpnState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpnState
  ): zio.aws.ec2.model.VpnState = value match {
    case software.amazon.awssdk.services.ec2.model.VpnState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpnState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.VpnState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.VpnState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.VpnState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VpnState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnState =
      software.amazon.awssdk.services.ec2.model.VpnState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.VpnState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnState =
      software.amazon.awssdk.services.ec2.model.VpnState.PENDING
  }
  case object available extends zio.aws.ec2.model.VpnState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnState =
      software.amazon.awssdk.services.ec2.model.VpnState.AVAILABLE
  }
  case object deleting extends zio.aws.ec2.model.VpnState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnState =
      software.amazon.awssdk.services.ec2.model.VpnState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.VpnState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VpnState =
      software.amazon.awssdk.services.ec2.model.VpnState.DELETED
  }
}
