package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  TransitGatewayConnectPeerId,
  TransitGatewayAttachmentId
}
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectPeer(
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    transitGatewayConnectPeerId: Optional[TransitGatewayConnectPeerId] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayConnectPeerState] =
      Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    connectPeerConfiguration: Optional[
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer = {
    import TransitGatewayConnectPeer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        transitGatewayConnectPeerId.map(value =>
          TransitGatewayConnectPeerId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayConnectPeerId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        connectPeerConfiguration.map(value => value.buildAwsValue())
      )(_.connectPeerConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnectPeer.wrap(buildAwsValue())
}
object TransitGatewayConnectPeer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnectPeer =
      zio.aws.ec2.model.TransitGatewayConnectPeer(
        transitGatewayAttachmentId.map(value => value),
        transitGatewayConnectPeerId.map(value => value),
        state.map(value => value),
        creationTime.map(value => value),
        connectPeerConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def transitGatewayConnectPeerId: Optional[TransitGatewayConnectPeerId]
    def state: Optional[zio.aws.ec2.model.TransitGatewayConnectPeerState]
    def creationTime: Optional[DateTime]
    def connectPeerConfiguration: Optional[
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly
    ]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayConnectPeerId
        : ZIO[Any, AwsError, TransitGatewayConnectPeerId] =
      AwsError.unwrapOptionField(
        "transitGatewayConnectPeerId",
        transitGatewayConnectPeerId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayConnectPeerState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getConnectPeerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectPeerConfiguration",
      connectPeerConfiguration
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
  ) extends zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly {
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transitGatewayConnectPeerId
        : Optional[TransitGatewayConnectPeerId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayConnectPeerId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayConnectPeerId(value)
      )
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayConnectPeerState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayConnectPeerState.wrap(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val connectPeerConfiguration: Optional[
      zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectPeerConfiguration())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayConnectPeerConfiguration.wrap(value)
      )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer
  ): zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly = new Wrapper(impl)
}
