package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TransitGateway(
    transitGatewayId: Optional[String] = Optional.Absent,
    transitGatewayArn: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayState] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.TransitGatewayOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGateway = {
    import TransitGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGateway
      .builder()
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(transitGatewayArn.map(value => value: java.lang.String))(
        _.transitGatewayArn
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGateway.ReadOnly =
    zio.aws.ec2.model.TransitGateway.wrap(buildAwsValue())
}
object TransitGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGateway =
      zio.aws.ec2.model.TransitGateway(
        transitGatewayId.map(value => value),
        transitGatewayArn.map(value => value),
        state.map(value => value),
        ownerId.map(value => value),
        description.map(value => value),
        creationTime.map(value => value),
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayId: Optional[String]
    def transitGatewayArn: Optional[String]
    def state: Optional[zio.aws.ec2.model.TransitGatewayState]
    def ownerId: Optional[String]
    def description: Optional[String]
    def creationTime: Optional[DateTime]
    def options: Optional[zio.aws.ec2.model.TransitGatewayOptions.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getTransitGatewayArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayArn", transitGatewayArn)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayState] =
      AwsError.unwrapOptionField("state", state)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGateway
  ) extends zio.aws.ec2.model.TransitGateway.ReadOnly {
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val transitGatewayArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayArn())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.TransitGatewayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.TransitGatewayState.wrap(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val options
        : Optional[zio.aws.ec2.model.TransitGatewayOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.ec2.model.TransitGatewayOptions.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGateway
  ): zio.aws.ec2.model.TransitGateway.ReadOnly = new Wrapper(impl)
}
