package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait StatisticType {
  def unwrap: software.amazon.awssdk.services.ec2.model.StatisticType
}
object StatisticType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.StatisticType
  ): zio.aws.ec2.model.StatisticType = value match {
    case software.amazon.awssdk.services.ec2.model.StatisticType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.StatisticType.P50 =>
      val r = p50
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.StatisticType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.StatisticType =
      software.amazon.awssdk.services.ec2.model.StatisticType.UNKNOWN_TO_SDK_VERSION
  }
  case object p50 extends zio.aws.ec2.model.StatisticType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.StatisticType =
      software.amazon.awssdk.services.ec2.model.StatisticType.P50
  }
}
