package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  Integer,
  SecurityGroupId,
  SecurityGroupRuleId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupRule(
    securityGroupRuleId: Optional[SecurityGroupRuleId] = Optional.Absent,
    groupId: Optional[SecurityGroupId] = Optional.Absent,
    groupOwnerId: Optional[String] = Optional.Absent,
    isEgress: Optional[Boolean] = Optional.Absent,
    ipProtocol: Optional[String] = Optional.Absent,
    fromPort: Optional[Integer] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    cidrIpv4: Optional[String] = Optional.Absent,
    cidrIpv6: Optional[String] = Optional.Absent,
    prefixListId: Optional[PrefixListResourceId] = Optional.Absent,
    referencedGroupInfo: Optional[zio.aws.ec2.model.ReferencedSecurityGroup] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRule = {
    import SecurityGroupRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRule
      .builder()
      .optionallyWith(
        securityGroupRuleId.map(value =>
          SecurityGroupRuleId.unwrap(value): java.lang.String
        )
      )(_.securityGroupRuleId)
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(groupOwnerId.map(value => value: java.lang.String))(
        _.groupOwnerId
      )
      .optionallyWith(isEgress.map(value => value: java.lang.Boolean))(
        _.isEgress
      )
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(cidrIpv4.map(value => value: java.lang.String))(
        _.cidrIpv4
      )
      .optionallyWith(cidrIpv6.map(value => value: java.lang.String))(
        _.cidrIpv6
      )
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(referencedGroupInfo.map(value => value.buildAwsValue()))(
        _.referencedGroupInfo
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRule.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRule.wrap(buildAwsValue())
}
object SecurityGroupRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRule =
      zio.aws.ec2.model.SecurityGroupRule(
        securityGroupRuleId.map(value => value),
        groupId.map(value => value),
        groupOwnerId.map(value => value),
        isEgress.map(value => value),
        ipProtocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value),
        cidrIpv4.map(value => value),
        cidrIpv6.map(value => value),
        prefixListId.map(value => value),
        referencedGroupInfo.map(value => value.asEditable),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def securityGroupRuleId: Optional[SecurityGroupRuleId]
    def groupId: Optional[SecurityGroupId]
    def groupOwnerId: Optional[String]
    def isEgress: Optional[Boolean]
    def ipProtocol: Optional[String]
    def fromPort: Optional[Integer]
    def toPort: Optional[Integer]
    def cidrIpv4: Optional[String]
    def cidrIpv6: Optional[String]
    def prefixListId: Optional[PrefixListResourceId]
    def referencedGroupInfo
        : Optional[zio.aws.ec2.model.ReferencedSecurityGroup.ReadOnly]
    def description: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getSecurityGroupRuleId: ZIO[Any, AwsError, SecurityGroupRuleId] =
      AwsError.unwrapOptionField("securityGroupRuleId", securityGroupRuleId)
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupOwnerId", groupOwnerId)
    def getIsEgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEgress", isEgress)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getCidrIpv4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv4", cidrIpv4)
    def getCidrIpv6: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv6", cidrIpv6)
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getReferencedGroupInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ReferencedSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("referencedGroupInfo", referencedGroupInfo)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRule
  ) extends zio.aws.ec2.model.SecurityGroupRule.ReadOnly {
    override val securityGroupRuleId: Optional[SecurityGroupRuleId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRuleId())
        .map(value => zio.aws.ec2.model.primitives.SecurityGroupRuleId(value))
    override val groupId: Optional[SecurityGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupOwnerId())
      .map(value => value: String)
    override val isEgress: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEgress())
      .map(value => value: Boolean)
    override val ipProtocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => value: String)
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val cidrIpv4: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIpv4())
      .map(value => value: String)
    override val cidrIpv6: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIpv6())
      .map(value => value: String)
    override val prefixListId: Optional[PrefixListResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListId())
        .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val referencedGroupInfo
        : Optional[zio.aws.ec2.model.ReferencedSecurityGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referencedGroupInfo())
        .map(value => zio.aws.ec2.model.ReferencedSecurityGroup.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRule
  ): zio.aws.ec2.model.SecurityGroupRule.ReadOnly = new Wrapper(impl)
}
