package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevokeSecurityGroupEgressResponse(
    returnValue: Optional[Boolean] = Optional.Absent,
    unknownIpPermissions: Optional[Iterable[zio.aws.ec2.model.IpPermission]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse = {
    import RevokeSecurityGroupEgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(
        unknownIpPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unknownIpPermissions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly =
    zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.wrap(buildAwsValue())
}
object RevokeSecurityGroupEgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RevokeSecurityGroupEgressResponse =
      zio.aws.ec2.model.RevokeSecurityGroupEgressResponse(
        returnValue.map(value => value),
        unknownIpPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def returnValue: Optional[Boolean]
    def unknownIpPermissions
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getUnknownIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("unknownIpPermissions", unknownIpPermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse
  ) extends zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
    override val unknownIpPermissions
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unknownIpPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpPermission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse
  ): zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly = new Wrapper(
    impl
  )
}
