package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PayerResponsibility {
  def unwrap: software.amazon.awssdk.services.ec2.model.PayerResponsibility
}
object PayerResponsibility {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PayerResponsibility
  ): zio.aws.ec2.model.PayerResponsibility = value match {
    case software.amazon.awssdk.services.ec2.model.PayerResponsibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PayerResponsibility.SERVICE_OWNER =>
      val r = ServiceOwner
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.PayerResponsibility {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PayerResponsibility =
      software.amazon.awssdk.services.ec2.model.PayerResponsibility.UNKNOWN_TO_SDK_VERSION
  }
  case object ServiceOwner extends zio.aws.ec2.model.PayerResponsibility {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PayerResponsibility =
      software.amazon.awssdk.services.ec2.model.PayerResponsibility.SERVICE_OWNER
  }
}
