package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInterfaceStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus
}
object NetworkInterfaceStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus
  ): zio.aws.ec2.model.NetworkInterfaceStatus = value match {
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.ASSOCIATED =>
      val r = associated
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.ATTACHING =>
      val r = attaching
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.IN_USE =>
      val r = `in-use`
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.DETACHING =>
      val r = detaching
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NetworkInterfaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.ec2.model.NetworkInterfaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.AVAILABLE
  }
  case object associated extends zio.aws.ec2.model.NetworkInterfaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.ASSOCIATED
  }
  case object attaching extends zio.aws.ec2.model.NetworkInterfaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.ATTACHING
  }
  case object `in-use` extends zio.aws.ec2.model.NetworkInterfaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.IN_USE
  }
  case object detaching extends zio.aws.ec2.model.NetworkInterfaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus.DETACHING
  }
}
