package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait MembershipType {
  def unwrap: software.amazon.awssdk.services.ec2.model.MembershipType
}
object MembershipType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.MembershipType
  ): zio.aws.ec2.model.MembershipType = value match {
    case software.amazon.awssdk.services.ec2.model.MembershipType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.MembershipType.STATIC =>
      val r = static
      r
    case software.amazon.awssdk.services.ec2.model.MembershipType.IGMP =>
      val r = igmp
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.MembershipType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MembershipType =
      software.amazon.awssdk.services.ec2.model.MembershipType.UNKNOWN_TO_SDK_VERSION
  }
  case object static extends zio.aws.ec2.model.MembershipType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MembershipType =
      software.amazon.awssdk.services.ec2.model.MembershipType.STATIC
  }
  case object igmp extends zio.aws.ec2.model.MembershipType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MembershipType =
      software.amazon.awssdk.services.ec2.model.MembershipType.IGMP
  }
}
