package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait MarketType {
  def unwrap: software.amazon.awssdk.services.ec2.model.MarketType
}
object MarketType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.MarketType
  ): zio.aws.ec2.model.MarketType = value match {
    case software.amazon.awssdk.services.ec2.model.MarketType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.MarketType.SPOT =>
      val r = spot
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.MarketType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MarketType =
      software.amazon.awssdk.services.ec2.model.MarketType.UNKNOWN_TO_SDK_VERSION
  }
  case object spot extends zio.aws.ec2.model.MarketType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MarketType =
      software.amazon.awssdk.services.ec2.model.MarketType.SPOT
  }
}
