package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ListingStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.ListingStatus
}
object ListingStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ListingStatus
  ): zio.aws.ec2.model.ListingStatus = value match {
    case software.amazon.awssdk.services.ec2.model.ListingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ListingStatus.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.ListingStatus.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.ListingStatus.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.ListingStatus.CLOSED =>
      val r = closed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ListingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingStatus =
      software.amazon.awssdk.services.ec2.model.ListingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.ListingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingStatus =
      software.amazon.awssdk.services.ec2.model.ListingStatus.ACTIVE
  }
  case object pending extends zio.aws.ec2.model.ListingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingStatus =
      software.amazon.awssdk.services.ec2.model.ListingStatus.PENDING
  }
  case object cancelled extends zio.aws.ec2.model.ListingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingStatus =
      software.amazon.awssdk.services.ec2.model.ListingStatus.CANCELLED
  }
  case object closed extends zio.aws.ec2.model.ListingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ListingStatus =
      software.amazon.awssdk.services.ec2.model.ListingStatus.CLOSED
  }
}
