package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  NetworkInterfaceId,
  SecurityGroupId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateInstanceNetworkInterfaceSpecification(
    associateCarrierIpAddress: Optional[Boolean] = Optional.Absent,
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    deviceIndex: Optional[Integer] = Optional.Absent,
    groups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    interfaceType: Optional[String] = Optional.Absent,
    ipv6AddressCount: Optional[Integer] = Optional.Absent,
    ipv6Addresses: Optional[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    privateIpAddresses: Optional[
      Iterable[zio.aws.ec2.model.PrivateIpAddressSpecification]
    ] = Optional.Absent,
    secondaryPrivateIpAddressCount: Optional[Integer] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    networkCardIndex: Optional[Integer] = Optional.Absent,
    ipv4Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv4PrefixSpecificationResponse]
    ] = Optional.Absent,
    ipv4PrefixCount: Optional[Integer] = Optional.Absent,
    ipv6Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv6PrefixSpecificationResponse]
    ] = Optional.Absent,
    ipv6PrefixCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification = {
    import LaunchTemplateInstanceNetworkInterfaceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
      .builder()
      .optionallyWith(
        associateCarrierIpAddress.map(value => value: java.lang.Boolean)
      )(_.associateCarrierIpAddress)
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(deviceIndex.map(value => value: java.lang.Integer))(
        _.deviceIndex
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(interfaceType.map(value => value: java.lang.String))(
        _.interfaceType
      )
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value => value: java.lang.Integer)
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(ipv4PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv4PrefixCount
      )
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(ipv6PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv6PrefixCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
      .wrap(buildAwsValue())
}
object LaunchTemplateInstanceNetworkInterfaceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification =
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification(
        associateCarrierIpAddress.map(value => value),
        associatePublicIpAddress.map(value => value),
        deleteOnTermination.map(value => value),
        description.map(value => value),
        deviceIndex.map(value => value),
        groups.map(value => value),
        interfaceType.map(value => value),
        ipv6AddressCount.map(value => value),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaceId.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondaryPrivateIpAddressCount.map(value => value),
        subnetId.map(value => value),
        networkCardIndex.map(value => value),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv4PrefixCount.map(value => value),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6PrefixCount.map(value => value)
      )
    def associateCarrierIpAddress: Optional[Boolean]
    def associatePublicIpAddress: Optional[Boolean]
    def deleteOnTermination: Optional[Boolean]
    def description: Optional[String]
    def deviceIndex: Optional[Integer]
    def groups: Optional[List[SecurityGroupId]]
    def interfaceType: Optional[String]
    def ipv6AddressCount: Optional[Integer]
    def ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def privateIpAddress: Optional[String]
    def privateIpAddresses: Optional[
      List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]
    ]
    def secondaryPrivateIpAddressCount: Optional[Integer]
    def subnetId: Optional[SubnetId]
    def networkCardIndex: Optional[Integer]
    def ipv4Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.ReadOnly]
    ]
    def ipv4PrefixCount: Optional[Integer]
    def ipv6Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.ReadOnly]
    ]
    def ipv6PrefixCount: Optional[Integer]
    def getAssociateCarrierIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associateCarrierIpAddress", associateCarrierIpAddress)
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInterfaceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv4PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv4PrefixCount", ipv4PrefixCount)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getIpv6PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6PrefixCount", ipv6PrefixCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
  ) extends zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly {
    override val associateCarrierIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associateCarrierIpAddress())
        .map(value => value: Boolean)
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val deviceIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceIndex())
      .map(value => value: Integer)
    override val groups: Optional[List[SecurityGroupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val interfaceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.interfaceType())
      .map(value => value: String)
    override val ipv6AddressCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6AddressCount())
      .map(value => value: Integer)
    override val ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
          }.toList
        )
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val privateIpAddresses: Optional[
      List[zio.aws.ec2.model.PrivateIpAddressSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrivateIpAddressSpecification.wrap(item)
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryPrivateIpAddressCount())
        .map(value => value: Integer)
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val networkCardIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.networkCardIndex())
      .map(value => value: Integer)
    override val ipv4Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv4PrefixSpecificationResponse.wrap(item)
        }.toList
      )
    override val ipv4PrefixCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4PrefixCount())
      .map(value => value: Integer)
    override val ipv6Prefixes: Optional[
      List[zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Ipv6PrefixSpecificationResponse.wrap(item)
        }.toList
      )
    override val ipv6PrefixCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6PrefixCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
  ): zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly =
    new Wrapper(impl)
}
