package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateInstanceMarketOptions(
    marketType: Optional[zio.aws.ec2.model.MarketType] = Optional.Absent,
    spotOptions: Optional[zio.aws.ec2.model.LaunchTemplateSpotMarketOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions = {
    import LaunchTemplateInstanceMarketOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions
      .builder()
      .optionallyWith(marketType.map(value => value.unwrap))(_.marketType)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.wrap(buildAwsValue())
}
object LaunchTemplateInstanceMarketOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions =
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions(
        marketType.map(value => value),
        spotOptions.map(value => value.asEditable)
      )
    def marketType: Optional[zio.aws.ec2.model.MarketType]
    def spotOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateSpotMarketOptions.ReadOnly]
    def getMarketType: ZIO[Any, AwsError, zio.aws.ec2.model.MarketType] =
      AwsError.unwrapOptionField("marketType", marketType)
    def getSpotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateSpotMarketOptions.ReadOnly
    ] = AwsError.unwrapOptionField("spotOptions", spotOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions
  ) extends zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly {
    override val marketType: Optional[zio.aws.ec2.model.MarketType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.marketType())
        .map(value => zio.aws.ec2.model.MarketType.wrap(value))
    override val spotOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateSpotMarketOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotOptions())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateSpotMarketOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions
  ): zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly =
    new Wrapper(impl)
}
