package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamCidrAuthorizationContext(
    message: Optional[String] = Optional.Absent,
    signature: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamCidrAuthorizationContext = {
    import IpamCidrAuthorizationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamCidrAuthorizationContext
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(signature.map(value => value: java.lang.String))(
        _.signature
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly =
    zio.aws.ec2.model.IpamCidrAuthorizationContext.wrap(buildAwsValue())
}
object IpamCidrAuthorizationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamCidrAuthorizationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamCidrAuthorizationContext =
      zio.aws.ec2.model.IpamCidrAuthorizationContext(
        message.map(value => value),
        signature.map(value => value)
      )
    def message: Optional[String]
    def signature: Optional[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getSignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signature", signature)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamCidrAuthorizationContext
  ) extends zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val signature: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signature())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamCidrAuthorizationContext
  ): zio.aws.ec2.model.IpamCidrAuthorizationContext.ReadOnly = new Wrapper(impl)
}
