package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Location
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceTypeOffering(
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    locationType: Optional[zio.aws.ec2.model.LocationType] = Optional.Absent,
    location: Optional[Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceTypeOffering = {
    import InstanceTypeOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceTypeOffering
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(locationType.map(value => value.unwrap))(_.locationType)
      .optionallyWith(
        location.map(value => Location.unwrap(value): java.lang.String)
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceTypeOffering.ReadOnly =
    zio.aws.ec2.model.InstanceTypeOffering.wrap(buildAwsValue())
}
object InstanceTypeOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceTypeOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceTypeOffering =
      zio.aws.ec2.model.InstanceTypeOffering(
        instanceType.map(value => value),
        locationType.map(value => value),
        location.map(value => value)
      )
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def locationType: Optional[zio.aws.ec2.model.LocationType]
    def location: Optional[Location]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getLocationType: ZIO[Any, AwsError, zio.aws.ec2.model.LocationType] =
      AwsError.unwrapOptionField("locationType", locationType)
    def getLocation: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeOffering
  ) extends zio.aws.ec2.model.InstanceTypeOffering.ReadOnly {
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val locationType: Optional[zio.aws.ec2.model.LocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationType())
        .map(value => zio.aws.ec2.model.LocationType.wrap(value))
    override val location: Optional[Location] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.ec2.model.primitives.Location(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeOffering
  ): zio.aws.ec2.model.InstanceTypeOffering.ReadOnly = new Wrapper(impl)
}
