package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceStatusSummary(
    details: Optional[Iterable[zio.aws.ec2.model.InstanceStatusDetails]] =
      Optional.Absent,
    status: Optional[zio.aws.ec2.model.SummaryStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStatusSummary = {
    import InstanceStatusSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStatusSummary
      .builder()
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStatusSummary.ReadOnly =
    zio.aws.ec2.model.InstanceStatusSummary.wrap(buildAwsValue())
}
object InstanceStatusSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStatusSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStatusSummary =
      zio.aws.ec2.model.InstanceStatusSummary(
        details.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def details
        : Optional[List[zio.aws.ec2.model.InstanceStatusDetails.ReadOnly]]
    def status: Optional[zio.aws.ec2.model.SummaryStatus]
    def getDetails: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceStatusDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("details", details)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.SummaryStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatusSummary
  ) extends zio.aws.ec2.model.InstanceStatusSummary.ReadOnly {
    override val details
        : Optional[List[zio.aws.ec2.model.InstanceStatusDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.details())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceStatusDetails.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.ec2.model.SummaryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.SummaryStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatusSummary
  ): zio.aws.ec2.model.InstanceStatusSummary.ReadOnly = new Wrapper(impl)
}
