package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceMetadataOptionsResponse(
    state: Optional[zio.aws.ec2.model.InstanceMetadataOptionsState] =
      Optional.Absent,
    httpTokens: Optional[zio.aws.ec2.model.HttpTokensState] = Optional.Absent,
    httpPutResponseHopLimit: Optional[Integer] = Optional.Absent,
    httpEndpoint: Optional[zio.aws.ec2.model.InstanceMetadataEndpointState] =
      Optional.Absent,
    httpProtocolIpv6: Optional[
      zio.aws.ec2.model.InstanceMetadataProtocolState
    ] = Optional.Absent,
    instanceMetadataTags: Optional[
      zio.aws.ec2.model.InstanceMetadataTagsState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse = {
    import InstanceMetadataOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(httpTokens.map(value => value.unwrap))(_.httpTokens)
      .optionallyWith(
        httpPutResponseHopLimit.map(value => value: java.lang.Integer)
      )(_.httpPutResponseHopLimit)
      .optionallyWith(httpEndpoint.map(value => value.unwrap))(_.httpEndpoint)
      .optionallyWith(httpProtocolIpv6.map(value => value.unwrap))(
        _.httpProtocolIpv6
      )
      .optionallyWith(instanceMetadataTags.map(value => value.unwrap))(
        _.instanceMetadataTags
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly =
    zio.aws.ec2.model.InstanceMetadataOptionsResponse.wrap(buildAwsValue())
}
object InstanceMetadataOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceMetadataOptionsResponse =
      zio.aws.ec2.model.InstanceMetadataOptionsResponse(
        state.map(value => value),
        httpTokens.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpEndpoint.map(value => value),
        httpProtocolIpv6.map(value => value),
        instanceMetadataTags.map(value => value)
      )
    def state: Optional[zio.aws.ec2.model.InstanceMetadataOptionsState]
    def httpTokens: Optional[zio.aws.ec2.model.HttpTokensState]
    def httpPutResponseHopLimit: Optional[Integer]
    def httpEndpoint: Optional[zio.aws.ec2.model.InstanceMetadataEndpointState]
    def httpProtocolIpv6
        : Optional[zio.aws.ec2.model.InstanceMetadataProtocolState]
    def instanceMetadataTags
        : Optional[zio.aws.ec2.model.InstanceMetadataTagsState]
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataOptionsState] =
      AwsError.unwrapOptionField("state", state)
    def getHttpTokens: ZIO[Any, AwsError, zio.aws.ec2.model.HttpTokensState] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataEndpointState] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpProtocolIpv6
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataProtocolState] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
    def getInstanceMetadataTags
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataTagsState] =
      AwsError.unwrapOptionField("instanceMetadataTags", instanceMetadataTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
  ) extends zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly {
    override val state
        : Optional[zio.aws.ec2.model.InstanceMetadataOptionsState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsState.wrap(value)
        )
    override val httpTokens: Optional[zio.aws.ec2.model.HttpTokensState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpTokens())
        .map(value => zio.aws.ec2.model.HttpTokensState.wrap(value))
    override val httpPutResponseHopLimit: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value => value: Integer)
    override val httpEndpoint
        : Optional[zio.aws.ec2.model.InstanceMetadataEndpointState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpEndpoint())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataEndpointState.wrap(value)
        )
    override val httpProtocolIpv6
        : Optional[zio.aws.ec2.model.InstanceMetadataProtocolState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpProtocolIpv6())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataProtocolState.wrap(value)
        )
    override val instanceMetadataTags
        : Optional[zio.aws.ec2.model.InstanceMetadataTagsState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMetadataTags())
        .map(value => zio.aws.ec2.model.InstanceMetadataTagsState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
  ): zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
