package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HibernationOptionsRequest(
    configured: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HibernationOptionsRequest = {
    import HibernationOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HibernationOptionsRequest
      .builder()
      .optionallyWith(configured.map(value => value: java.lang.Boolean))(
        _.configured
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly =
    zio.aws.ec2.model.HibernationOptionsRequest.wrap(buildAwsValue())
}
object HibernationOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HibernationOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HibernationOptionsRequest =
      zio.aws.ec2.model
        .HibernationOptionsRequest(configured.map(value => value))
    def configured: Optional[Boolean]
    def getConfigured: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("configured", configured)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HibernationOptionsRequest
  ) extends zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly {
    override val configured: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.configured())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HibernationOptionsRequest
  ): zio.aws.ec2.model.HibernationOptionsRequest.ReadOnly = new Wrapper(impl)
}
