package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  IpamAddressHistoryMaxResults,
  MillisecondDateTime,
  IpamScopeId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetIpamAddressHistoryRequest(
    cidr: String,
    ipamScopeId: IpamScopeId,
    vpcId: Optional[String] = Optional.Absent,
    startTime: Optional[MillisecondDateTime] = Optional.Absent,
    endTime: Optional[MillisecondDateTime] = Optional.Absent,
    maxResults: Optional[IpamAddressHistoryMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest = {
    import GetIpamAddressHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        maxResults.map(value =>
          IpamAddressHistoryMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamAddressHistoryRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamAddressHistoryRequest.wrap(buildAwsValue())
}
object GetIpamAddressHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamAddressHistoryRequest =
      zio.aws.ec2.model.GetIpamAddressHistoryRequest(
        cidr,
        ipamScopeId,
        vpcId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def cidr: String
    def ipamScopeId: IpamScopeId
    def vpcId: Optional[String]
    def startTime: Optional[MillisecondDateTime]
    def endTime: Optional[MillisecondDateTime]
    def maxResults: Optional[IpamAddressHistoryMaxResults]
    def nextToken: Optional[NextToken]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, IpamAddressHistoryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
  ) extends zio.aws.ec2.model.GetIpamAddressHistoryRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val startTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endTime: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val maxResults: Optional[IpamAddressHistoryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.IpamAddressHistoryMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest
  ): zio.aws.ec2.model.GetIpamAddressHistoryRequest.ReadOnly = new Wrapper(impl)
}
