package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetInstanceMatchCriteria {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria
}
object FleetInstanceMatchCriteria {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria
  ): zio.aws.ec2.model.FleetInstanceMatchCriteria = value match {
    case software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria.OPEN =>
      val r = open
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FleetInstanceMatchCriteria {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria =
      software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria.UNKNOWN_TO_SDK_VERSION
  }
  case object open extends zio.aws.ec2.model.FleetInstanceMatchCriteria {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria =
      software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria.OPEN
  }
}
