package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableSerialConsoleAccessResponse(
    serialConsoleAccessEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse = {
    import EnableSerialConsoleAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse
      .builder()
      .optionallyWith(
        serialConsoleAccessEnabled.map(value => value: java.lang.Boolean)
      )(_.serialConsoleAccessEnabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly =
    zio.aws.ec2.model.EnableSerialConsoleAccessResponse.wrap(buildAwsValue())
}
object EnableSerialConsoleAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableSerialConsoleAccessResponse =
      zio.aws.ec2.model.EnableSerialConsoleAccessResponse(
        serialConsoleAccessEnabled.map(value => value)
      )
    def serialConsoleAccessEnabled: Optional[Boolean]
    def getSerialConsoleAccessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "serialConsoleAccessEnabled",
        serialConsoleAccessEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse
  ) extends zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly {
    override val serialConsoleAccessEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialConsoleAccessEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse
  ): zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
