package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnableAwsNetworkPerformanceMetricSubscriptionResponse(
    output: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse = {
    import EnableAwsNetworkPerformanceMetricSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse
      .builder()
      .optionallyWith(output.map(value => value: java.lang.Boolean))(_.output)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse.ReadOnly =
    zio.aws.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse
      .wrap(buildAwsValue())
}
object EnableAwsNetworkPerformanceMetricSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse =
      zio.aws.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse(
        output.map(value => value)
      )
    def output: Optional[Boolean]
    def getOutput: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("output", output)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse
  ) extends zio.aws.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse.ReadOnly {
    override val output: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse
  ): zio.aws.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
