package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DnsSupportValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.DnsSupportValue
}
object DnsSupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DnsSupportValue
  ): zio.aws.ec2.model.DnsSupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.DnsSupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DnsSupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.DnsSupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DnsSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsSupportValue =
      software.amazon.awssdk.services.ec2.model.DnsSupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.DnsSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsSupportValue =
      software.amazon.awssdk.services.ec2.model.DnsSupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.DnsSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsSupportValue =
      software.amazon.awssdk.services.ec2.model.DnsSupportValue.DISABLE
  }
}
