package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DescribeVpcClassicLinkDnsSupportNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcClassicLinkDnsSupportResponse(
    nextToken: Optional[DescribeVpcClassicLinkDnsSupportNextToken] =
      Optional.Absent,
    vpcs: Optional[Iterable[zio.aws.ec2.model.ClassicLinkDnsSupport]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse = {
    import DescribeVpcClassicLinkDnsSupportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          DescribeVpcClassicLinkDnsSupportNextToken.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        vpcs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcs)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse
      .wrap(buildAwsValue())
}
object DescribeVpcClassicLinkDnsSupportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse =
      zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse(
        nextToken.map(value => value),
        vpcs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[DescribeVpcClassicLinkDnsSupportNextToken]
    def vpcs: Optional[List[zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly]]
    def getNextToken
        : ZIO[Any, AwsError, DescribeVpcClassicLinkDnsSupportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcs", vpcs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse
  ) extends zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly {
    override val nextToken
        : Optional[DescribeVpcClassicLinkDnsSupportNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVpcClassicLinkDnsSupportNextToken(value)
        )
    override val vpcs
        : Optional[List[zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ClassicLinkDnsSupport.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse
  ): zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly =
    new Wrapper(impl)
}
