package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VolumeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumesRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    volumeIds: Optional[Iterable[VolumeId]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest = {
    import DescribeVolumesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        volumeIds.map(value =>
          value.map { item =>
            VolumeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesRequest.wrap(buildAwsValue())
}
object DescribeVolumesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesRequest =
      zio.aws.ec2.model.DescribeVolumesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def volumeIds: Optional[List[VolumeId]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVolumeIds: ZIO[Any, AwsError, List[VolumeId]] =
      AwsError.unwrapOptionField("volumeIds", volumeIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
  ) extends zio.aws.ec2.model.DescribeVolumesRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val volumeIds: Optional[List[VolumeId]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VolumeId(item)
        }.toList
      )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest
  ): zio.aws.ec2.model.DescribeVolumesRequest.ReadOnly = new Wrapper(impl)
}
