package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeRegionsResponse(
    regions: Optional[Iterable[zio.aws.ec2.model.Region]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse = {
    import DescribeRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse
      .builder()
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeRegionsResponse.wrap(buildAwsValue())
}
object DescribeRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeRegionsResponse =
      zio.aws.ec2.model.DescribeRegionsResponse(
        regions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def regions: Optional[List[zio.aws.ec2.model.Region.ReadOnly]]
    def getRegions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Region.ReadOnly]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse
  ) extends zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly {
    override val regions: Optional[List[zio.aws.ec2.model.Region.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Region.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse
  ): zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly = new Wrapper(impl)
}
