package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ConversionTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeConversionTasksRequest(
    conversionTaskIds: Optional[Iterable[ConversionTaskId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest = {
    import DescribeConversionTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
      .builder()
      .optionallyWith(
        conversionTaskIds.map(value =>
          value.map { item =>
            ConversionTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.conversionTaskIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeConversionTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeConversionTasksRequest.wrap(buildAwsValue())
}
object DescribeConversionTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeConversionTasksRequest =
      zio.aws.ec2.model
        .DescribeConversionTasksRequest(conversionTaskIds.map(value => value))
    def conversionTaskIds: Optional[List[ConversionTaskId]]
    def getConversionTaskIds: ZIO[Any, AwsError, List[ConversionTaskId]] =
      AwsError.unwrapOptionField("conversionTaskIds", conversionTaskIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
  ) extends zio.aws.ec2.model.DescribeConversionTasksRequest.ReadOnly {
    override val conversionTaskIds: Optional[List[ConversionTaskId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversionTaskIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ConversionTaskId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest
  ): zio.aws.ec2.model.DescribeConversionTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
