package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAnalysisResponse(
    networkInsightsAnalysisId: Optional[NetworkInsightsAnalysisId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse = {
    import DeleteNetworkInsightsAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse
      .builder()
      .optionallyWith(
        networkInsightsAnalysisId.map(value =>
          NetworkInsightsAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAnalysisId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse
      .wrap(buildAwsValue())
}
object DeleteNetworkInsightsAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse =
      zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse(
        networkInsightsAnalysisId.map(value => value)
      )
    def networkInsightsAnalysisId: Optional[NetworkInsightsAnalysisId]
    def getNetworkInsightsAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAnalysisId] = AwsError
      .unwrapOptionField("networkInsightsAnalysisId", networkInsightsAnalysisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly {
    override val networkInsightsAnalysisId
        : Optional[NetworkInsightsAnalysisId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse
  ): zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
