package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessInstanceResponse(
    verifiedAccessInstance: Optional[zio.aws.ec2.model.VerifiedAccessInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse = {
    import CreateVerifiedAccessInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse
      .builder()
      .optionallyWith(
        verifiedAccessInstance.map(value => value.buildAwsValue())
      )(_.verifiedAccessInstance)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessInstanceResponse.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessInstanceResponse.wrap(buildAwsValue())
}
object CreateVerifiedAccessInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessInstanceResponse =
      zio.aws.ec2.model.CreateVerifiedAccessInstanceResponse(
        verifiedAccessInstance.map(value => value.asEditable)
      )
    def verifiedAccessInstance
        : Optional[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly]
    def getVerifiedAccessInstance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessInstance",
      verifiedAccessInstance
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse
  ) extends zio.aws.ec2.model.CreateVerifiedAccessInstanceResponse.ReadOnly {
    override val verifiedAccessInstance
        : Optional[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstance())
        .map(value => zio.aws.ec2.model.VerifiedAccessInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse
  ): zio.aws.ec2.model.CreateVerifiedAccessInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
