package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClientVpnRouteResponse(
    status: Optional[zio.aws.ec2.model.ClientVpnRouteStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse = {
    import CreateClientVpnRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly =
    zio.aws.ec2.model.CreateClientVpnRouteResponse.wrap(buildAwsValue())
}
object CreateClientVpnRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateClientVpnRouteResponse =
      zio.aws.ec2.model
        .CreateClientVpnRouteResponse(status.map(value => value.asEditable))
    def status: Optional[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse
  ) extends zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly {
    override val status
        : Optional[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ClientVpnRouteStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse
  ): zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly = new Wrapper(impl)
}
