package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  CapacityReservationFleetId
}
import scala.jdk.CollectionConverters._
final case class CapacityReservationFleet(
    capacityReservationFleetId: Optional[CapacityReservationFleetId] =
      Optional.Absent,
    capacityReservationFleetArn: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.CapacityReservationFleetState] =
      Optional.Absent,
    totalTargetCapacity: Optional[Integer] = Optional.Absent,
    totalFulfilledCapacity: Optional[Double] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy] =
      Optional.Absent,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    createTime: Optional[MillisecondDateTime] = Optional.Absent,
    instanceMatchCriteria: Optional[
      zio.aws.ec2.model.FleetInstanceMatchCriteria
    ] = Optional.Absent,
    allocationStrategy: Optional[String] = Optional.Absent,
    instanceTypeSpecifications: Optional[
      Iterable[zio.aws.ec2.model.FleetCapacityReservation]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationFleet = {
    import CapacityReservationFleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationFleet
      .builder()
      .optionallyWith(
        capacityReservationFleetId.map(value =>
          CapacityReservationFleetId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationFleetId)
      .optionallyWith(
        capacityReservationFleetArn.map(value => value: java.lang.String)
      )(_.capacityReservationFleetArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        totalTargetCapacity.map(value => value: java.lang.Integer)
      )(_.totalTargetCapacity)
      .optionallyWith(
        totalFulfilledCapacity.map(value => value: java.lang.Double)
      )(_.totalFulfilledCapacity)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(
        createTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(allocationStrategy.map(value => value: java.lang.String))(
        _.allocationStrategy
      )
      .optionallyWith(
        instanceTypeSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypeSpecifications)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationFleet.ReadOnly =
    zio.aws.ec2.model.CapacityReservationFleet.wrap(buildAwsValue())
}
object CapacityReservationFleet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationFleet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationFleet =
      zio.aws.ec2.model.CapacityReservationFleet(
        capacityReservationFleetId.map(value => value),
        capacityReservationFleetArn.map(value => value),
        state.map(value => value),
        totalTargetCapacity.map(value => value),
        totalFulfilledCapacity.map(value => value),
        tenancy.map(value => value),
        endDate.map(value => value),
        createTime.map(value => value),
        instanceMatchCriteria.map(value => value),
        allocationStrategy.map(value => value),
        instanceTypeSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationFleetId: Optional[CapacityReservationFleetId]
    def capacityReservationFleetArn: Optional[String]
    def state: Optional[zio.aws.ec2.model.CapacityReservationFleetState]
    def totalTargetCapacity: Optional[Integer]
    def totalFulfilledCapacity: Optional[Double]
    def tenancy: Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy]
    def endDate: Optional[MillisecondDateTime]
    def createTime: Optional[MillisecondDateTime]
    def instanceMatchCriteria
        : Optional[zio.aws.ec2.model.FleetInstanceMatchCriteria]
    def allocationStrategy: Optional[String]
    def instanceTypeSpecifications
        : Optional[List[zio.aws.ec2.model.FleetCapacityReservation.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCapacityReservationFleetId
        : ZIO[Any, AwsError, CapacityReservationFleetId] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
    def getCapacityReservationFleetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetArn",
        capacityReservationFleetArn
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationFleetState] =
      AwsError.unwrapOptionField("state", state)
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getTotalFulfilledCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("totalFulfilledCapacity", totalFulfilledCapacity)
    def getTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationTenancy
    ] = AwsError.unwrapOptionField("tenancy", tenancy)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getCreateTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getAllocationStrategy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getInstanceTypeSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetCapacityReservation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceTypeSpecifications",
      instanceTypeSpecifications
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationFleet
  ) extends zio.aws.ec2.model.CapacityReservationFleet.ReadOnly {
    override val capacityReservationFleetId
        : Optional[CapacityReservationFleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationFleetId())
      .map(value =>
        zio.aws.ec2.model.primitives.CapacityReservationFleetId(value)
      )
    override val capacityReservationFleetArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationFleetArn())
        .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.CapacityReservationFleetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationFleetState.wrap(value)
        )
    override val totalTargetCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalTargetCapacity())
      .map(value => value: Integer)
    override val totalFulfilledCapacity: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalFulfilledCapacity())
        .map(value => value: Double)
    override val tenancy
        : Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value =>
          zio.aws.ec2.model.FleetCapacityReservationTenancy.wrap(value)
        )
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val createTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val instanceMatchCriteria
        : Optional[zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMatchCriteria())
        .map(value => zio.aws.ec2.model.FleetInstanceMatchCriteria.wrap(value))
    override val allocationStrategy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationStrategy())
      .map(value => value: String)
    override val instanceTypeSpecifications
        : Optional[List[zio.aws.ec2.model.FleetCapacityReservation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTypeSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FleetCapacityReservation.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationFleet
  ): zio.aws.ec2.model.CapacityReservationFleet.ReadOnly = new Wrapper(impl)
}
