package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ApplianceModeSupportValue {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue
}
object ApplianceModeSupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue
  ): zio.aws.ec2.model.ApplianceModeSupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ApplianceModeSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue =
      software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.ApplianceModeSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue =
      software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.ApplianceModeSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue =
      software.amazon.awssdk.services.ec2.model.ApplianceModeSupportValue.DISABLE
  }
}
