package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnalysisRouteTableRoute(
    destinationCidr: Optional[String] = Optional.Absent,
    destinationPrefixListId: Optional[String] = Optional.Absent,
    egressOnlyInternetGatewayId: Optional[String] = Optional.Absent,
    gatewayId: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    natGatewayId: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    origin: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    vpcPeeringConnectionId: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute = {
    import AnalysisRouteTableRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
      .builder()
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(
        destinationPrefixListId.map(value => value: java.lang.String)
      )(_.destinationPrefixListId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value => value: java.lang.String)
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(origin.map(value => value: java.lang.String))(_.origin)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly =
    zio.aws.ec2.model.AnalysisRouteTableRoute.wrap(buildAwsValue())
}
object AnalysisRouteTableRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AnalysisRouteTableRoute =
      zio.aws.ec2.model.AnalysisRouteTableRoute(
        destinationCidr.map(value => value),
        destinationPrefixListId.map(value => value),
        egressOnlyInternetGatewayId.map(value => value),
        gatewayId.map(value => value),
        instanceId.map(value => value),
        natGatewayId.map(value => value),
        networkInterfaceId.map(value => value),
        origin.map(value => value),
        transitGatewayId.map(value => value),
        vpcPeeringConnectionId.map(value => value),
        state.map(value => value)
      )
    def destinationCidr: Optional[String]
    def destinationPrefixListId: Optional[String]
    def egressOnlyInternetGatewayId: Optional[String]
    def gatewayId: Optional[String]
    def instanceId: Optional[String]
    def natGatewayId: Optional[String]
    def networkInterfaceId: Optional[String]
    def origin: Optional[String]
    def transitGatewayId: Optional[String]
    def vpcPeeringConnectionId: Optional[String]
    def state: Optional[String]
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getDestinationPrefixListId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationPrefixListId", destinationPrefixListId)
    def getEgressOnlyInternetGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOrigin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("origin", origin)
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
  ) extends zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly {
    override val destinationCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidr())
      .map(value => value: String)
    override val destinationPrefixListId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => value: String)
    override val egressOnlyInternetGatewayId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressOnlyInternetGatewayId())
        .map(value => value: String)
    override val gatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val natGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val origin: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.origin())
      .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val vpcPeeringConnectionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AnalysisRouteTableRoute
  ): zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly = new Wrapper(impl)
}
