package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AllocateHostsResponse(
    hostIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateHostsResponse = {
    import AllocateHostsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateHostsResponse
      .builder()
      .optionallyWith(
        hostIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.hostIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateHostsResponse.ReadOnly =
    zio.aws.ec2.model.AllocateHostsResponse.wrap(buildAwsValue())
}
object AllocateHostsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateHostsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateHostsResponse =
      zio.aws.ec2.model.AllocateHostsResponse(hostIds.map(value => value))
    def hostIds: Optional[List[String]]
    def getHostIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("hostIds", hostIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateHostsResponse
  ) extends zio.aws.ec2.model.AllocateHostsResponse.ReadOnly {
    override val hostIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.hostIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateHostsResponse
  ): zio.aws.ec2.model.AllocateHostsResponse.ReadOnly = new Wrapper(impl)
}
