package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class VolumeModification(
    volumeId: Optional[String] = Optional.Absent,
    modificationState: Optional[zio.aws.ec2.model.VolumeModificationState] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    targetSize: Optional[Integer] = Optional.Absent,
    targetIops: Optional[Integer] = Optional.Absent,
    targetVolumeType: Optional[zio.aws.ec2.model.VolumeType] = Optional.Absent,
    targetThroughput: Optional[Integer] = Optional.Absent,
    targetMultiAttachEnabled: Optional[Boolean] = Optional.Absent,
    originalSize: Optional[Integer] = Optional.Absent,
    originalIops: Optional[Integer] = Optional.Absent,
    originalVolumeType: Optional[zio.aws.ec2.model.VolumeType] =
      Optional.Absent,
    originalThroughput: Optional[Integer] = Optional.Absent,
    originalMultiAttachEnabled: Optional[Boolean] = Optional.Absent,
    progress: Optional[Long] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeModification = {
    import VolumeModification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeModification
      .builder()
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(modificationState.map(value => value.unwrap))(
        _.modificationState
      )
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(targetSize.map(value => value: java.lang.Integer))(
        _.targetSize
      )
      .optionallyWith(targetIops.map(value => value: java.lang.Integer))(
        _.targetIops
      )
      .optionallyWith(targetVolumeType.map(value => value.unwrap))(
        _.targetVolumeType
      )
      .optionallyWith(targetThroughput.map(value => value: java.lang.Integer))(
        _.targetThroughput
      )
      .optionallyWith(
        targetMultiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.targetMultiAttachEnabled)
      .optionallyWith(originalSize.map(value => value: java.lang.Integer))(
        _.originalSize
      )
      .optionallyWith(originalIops.map(value => value: java.lang.Integer))(
        _.originalIops
      )
      .optionallyWith(originalVolumeType.map(value => value.unwrap))(
        _.originalVolumeType
      )
      .optionallyWith(
        originalThroughput.map(value => value: java.lang.Integer)
      )(_.originalThroughput)
      .optionallyWith(
        originalMultiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.originalMultiAttachEnabled)
      .optionallyWith(progress.map(value => value: java.lang.Long))(_.progress)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeModification.ReadOnly =
    zio.aws.ec2.model.VolumeModification.wrap(buildAwsValue())
}
object VolumeModification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeModification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeModification =
      zio.aws.ec2.model.VolumeModification(
        volumeId.map(value => value),
        modificationState.map(value => value),
        statusMessage.map(value => value),
        targetSize.map(value => value),
        targetIops.map(value => value),
        targetVolumeType.map(value => value),
        targetThroughput.map(value => value),
        targetMultiAttachEnabled.map(value => value),
        originalSize.map(value => value),
        originalIops.map(value => value),
        originalVolumeType.map(value => value),
        originalThroughput.map(value => value),
        originalMultiAttachEnabled.map(value => value),
        progress.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def volumeId: Optional[String]
    def modificationState: Optional[zio.aws.ec2.model.VolumeModificationState]
    def statusMessage: Optional[String]
    def targetSize: Optional[Integer]
    def targetIops: Optional[Integer]
    def targetVolumeType: Optional[zio.aws.ec2.model.VolumeType]
    def targetThroughput: Optional[Integer]
    def targetMultiAttachEnabled: Optional[Boolean]
    def originalSize: Optional[Integer]
    def originalIops: Optional[Integer]
    def originalVolumeType: Optional[zio.aws.ec2.model.VolumeType]
    def originalThroughput: Optional[Integer]
    def originalMultiAttachEnabled: Optional[Boolean]
    def progress: Optional[Long]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getModificationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeModificationState] =
      AwsError.unwrapOptionField("modificationState", modificationState)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTargetSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetSize", targetSize)
    def getTargetIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetIops", targetIops)
    def getTargetVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("targetVolumeType", targetVolumeType)
    def getTargetThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetThroughput", targetThroughput)
    def getTargetMultiAttachEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("targetMultiAttachEnabled", targetMultiAttachEnabled)
    def getOriginalSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originalSize", originalSize)
    def getOriginalIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originalIops", originalIops)
    def getOriginalVolumeType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("originalVolumeType", originalVolumeType)
    def getOriginalThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originalThroughput", originalThroughput)
    def getOriginalMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "originalMultiAttachEnabled",
        originalMultiAttachEnabled
      )
    def getProgress: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("progress", progress)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeModification
  ) extends zio.aws.ec2.model.VolumeModification.ReadOnly {
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
    override val modificationState
        : Optional[zio.aws.ec2.model.VolumeModificationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationState())
        .map(value => zio.aws.ec2.model.VolumeModificationState.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val targetSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetSize())
      .map(value => value: Integer)
    override val targetIops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetIops())
      .map(value => value: Integer)
    override val targetVolumeType: Optional[zio.aws.ec2.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVolumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val targetThroughput: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetThroughput())
      .map(value => value: Integer)
    override val targetMultiAttachEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMultiAttachEnabled())
        .map(value => value: Boolean)
    override val originalSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.originalSize())
      .map(value => value: Integer)
    override val originalIops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.originalIops())
      .map(value => value: Integer)
    override val originalVolumeType: Optional[zio.aws.ec2.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originalVolumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val originalThroughput: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.originalThroughput())
      .map(value => value: Integer)
    override val originalMultiAttachEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originalMultiAttachEnabled())
        .map(value => value: Boolean)
    override val progress: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: Long)
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeModification
  ): zio.aws.ec2.model.VolumeModification.ReadOnly = new Wrapper(impl)
}
