package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VerifiedAccessEndpointProtocol {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol
}
object VerifiedAccessEndpointProtocol {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol
  ): zio.aws.ec2.model.VerifiedAccessEndpointProtocol = value match {
    case software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol.HTTP =>
      val r = http
      r
    case software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol.HTTPS =>
      val r = https
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VerifiedAccessEndpointProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol =
      software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object http extends zio.aws.ec2.model.VerifiedAccessEndpointProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol =
      software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol.HTTP
  }
  case object https extends zio.aws.ec2.model.VerifiedAccessEndpointProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol =
      software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointProtocol.HTTPS
  }
}
