package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReservedInstancesConfiguration(
    availabilityZone: Optional[String] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    scope: Optional[zio.aws.ec2.model.Scope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration = {
    import ReservedInstancesConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesConfiguration.wrap(buildAwsValue())
}
object ReservedInstancesConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesConfiguration =
      zio.aws.ec2.model.ReservedInstancesConfiguration(
        availabilityZone.map(value => value),
        instanceCount.map(value => value),
        instanceType.map(value => value),
        platform.map(value => value),
        scope.map(value => value)
      )
    def availabilityZone: Optional[String]
    def instanceCount: Optional[Integer]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def platform: Optional[String]
    def scope: Optional[zio.aws.ec2.model.Scope]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getScope: ZIO[Any, AwsError, zio.aws.ec2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration
  ) extends zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val scope: Optional[zio.aws.ec2.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.ec2.model.Scope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration
  ): zio.aws.ec2.model.ReservedInstancesConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
