package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  NetworkInsightsPathId,
  ResourceArn,
  NetworkInsightsAnalysisId
}
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAnalysis(
    networkInsightsAnalysisId: Optional[NetworkInsightsAnalysisId] =
      Optional.Absent,
    networkInsightsAnalysisArn: Optional[ResourceArn] = Optional.Absent,
    networkInsightsPathId: Optional[NetworkInsightsPathId] = Optional.Absent,
    additionalAccounts: Optional[Iterable[String]] = Optional.Absent,
    filterInArns: Optional[Iterable[ResourceArn]] = Optional.Absent,
    startDate: Optional[MillisecondDateTime] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.AnalysisStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    warningMessage: Optional[String] = Optional.Absent,
    networkPathFound: Optional[Boolean] = Optional.Absent,
    forwardPathComponents: Optional[Iterable[zio.aws.ec2.model.PathComponent]] =
      Optional.Absent,
    returnPathComponents: Optional[Iterable[zio.aws.ec2.model.PathComponent]] =
      Optional.Absent,
    explanations: Optional[Iterable[zio.aws.ec2.model.Explanation]] =
      Optional.Absent,
    alternatePathHints: Optional[
      Iterable[zio.aws.ec2.model.AlternatePathHint]
    ] = Optional.Absent,
    suggestedAccounts: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis = {
    import NetworkInsightsAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
      .builder()
      .optionallyWith(
        networkInsightsAnalysisId.map(value =>
          NetworkInsightsAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAnalysisId)
      .optionallyWith(
        networkInsightsAnalysisArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAnalysisArn)
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .optionallyWith(
        additionalAccounts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.additionalAccounts)
      .optionallyWith(
        filterInArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterInArns)
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(warningMessage.map(value => value: java.lang.String))(
        _.warningMessage
      )
      .optionallyWith(networkPathFound.map(value => value: java.lang.Boolean))(
        _.networkPathFound
      )
      .optionallyWith(
        forwardPathComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.forwardPathComponents)
      .optionallyWith(
        returnPathComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.returnPathComponents)
      .optionallyWith(
        explanations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.explanations)
      .optionallyWith(
        alternatePathHints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternatePathHints)
      .optionallyWith(
        suggestedAccounts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.suggestedAccounts)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAnalysis.wrap(buildAwsValue())
}
object NetworkInsightsAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAnalysis =
      zio.aws.ec2.model.NetworkInsightsAnalysis(
        networkInsightsAnalysisId.map(value => value),
        networkInsightsAnalysisArn.map(value => value),
        networkInsightsPathId.map(value => value),
        additionalAccounts.map(value => value),
        filterInArns.map(value => value),
        startDate.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        warningMessage.map(value => value),
        networkPathFound.map(value => value),
        forwardPathComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        returnPathComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        explanations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alternatePathHints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        suggestedAccounts.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAnalysisId: Optional[NetworkInsightsAnalysisId]
    def networkInsightsAnalysisArn: Optional[ResourceArn]
    def networkInsightsPathId: Optional[NetworkInsightsPathId]
    def additionalAccounts: Optional[List[String]]
    def filterInArns: Optional[List[ResourceArn]]
    def startDate: Optional[MillisecondDateTime]
    def status: Optional[zio.aws.ec2.model.AnalysisStatus]
    def statusMessage: Optional[String]
    def warningMessage: Optional[String]
    def networkPathFound: Optional[Boolean]
    def forwardPathComponents
        : Optional[List[zio.aws.ec2.model.PathComponent.ReadOnly]]
    def returnPathComponents
        : Optional[List[zio.aws.ec2.model.PathComponent.ReadOnly]]
    def explanations: Optional[List[zio.aws.ec2.model.Explanation.ReadOnly]]
    def alternatePathHints
        : Optional[List[zio.aws.ec2.model.AlternatePathHint.ReadOnly]]
    def suggestedAccounts: Optional[List[String]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAnalysisId] = AwsError
      .unwrapOptionField("networkInsightsAnalysisId", networkInsightsAnalysisId)
    def getNetworkInsightsAnalysisArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField(
        "networkInsightsAnalysisArn",
        networkInsightsAnalysisArn
      )
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
    def getAdditionalAccounts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("additionalAccounts", additionalAccounts)
    def getFilterInArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("filterInArns", filterInArns)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getWarningMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warningMessage", warningMessage)
    def getNetworkPathFound: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("networkPathFound", networkPathFound)
    def getForwardPathComponents
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      AwsError.unwrapOptionField("forwardPathComponents", forwardPathComponents)
    def getReturnPathComponents
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      AwsError.unwrapOptionField("returnPathComponents", returnPathComponents)
    def getExplanations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Explanation.ReadOnly]] =
      AwsError.unwrapOptionField("explanations", explanations)
    def getAlternatePathHints: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AlternatePathHint.ReadOnly
    ]] = AwsError.unwrapOptionField("alternatePathHints", alternatePathHints)
    def getSuggestedAccounts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("suggestedAccounts", suggestedAccounts)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
  ) extends zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly {
    override val networkInsightsAnalysisId
        : Optional[NetworkInsightsAnalysisId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId(value)
      )
    override val networkInsightsAnalysisArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsAnalysisArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val networkInsightsPathId: Optional[NetworkInsightsPathId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsPathId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
    override val additionalAccounts: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalAccounts())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val filterInArns: Optional[List[ResourceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterInArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ResourceArn(item)
          }.toList
        )
    override val startDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val status: Optional[zio.aws.ec2.model.AnalysisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.AnalysisStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val warningMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.warningMessage())
      .map(value => value: String)
    override val networkPathFound: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.networkPathFound())
      .map(value => value: Boolean)
    override val forwardPathComponents
        : Optional[List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forwardPathComponents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PathComponent.wrap(item)
          }.toList
        )
    override val returnPathComponents
        : Optional[List[zio.aws.ec2.model.PathComponent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnPathComponents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PathComponent.wrap(item)
          }.toList
        )
    override val explanations
        : Optional[List[zio.aws.ec2.model.Explanation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explanations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Explanation.wrap(item)
          }.toList
        )
    override val alternatePathHints
        : Optional[List[zio.aws.ec2.model.AlternatePathHint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternatePathHints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AlternatePathHint.wrap(item)
          }.toList
        )
    override val suggestedAccounts: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestedAccounts())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysis
  ): zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly = new Wrapper(impl)
}
