package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  LocalGatewayVirtualInterfaceGroupId,
  LocalGatewayRoutetableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyLocalGatewayRouteRequest(
    destinationCidrBlock: String,
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    localGatewayVirtualInterfaceGroupId: Optional[
      LocalGatewayVirtualInterfaceGroupId
    ] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest = {
    import ModifyLocalGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
      .builder()
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.wrap(buildAwsValue())
}
object ModifyLocalGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyLocalGatewayRouteRequest =
      zio.aws.ec2.model.ModifyLocalGatewayRouteRequest(
        destinationCidrBlock,
        localGatewayRouteTableId,
        localGatewayVirtualInterfaceGroupId.map(value => value),
        networkInterfaceId.map(value => value)
      )
    def destinationCidrBlock: String
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
  ) extends zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.ReadOnly {
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val localGatewayVirtualInterfaceGroupId
        : Optional[LocalGatewayVirtualInterfaceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest
  ): zio.aws.ec2.model.ModifyLocalGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
