package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyFpgaImageAttributeResponse(
    fpgaImageAttribute: Optional[zio.aws.ec2.model.FpgaImageAttribute] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse = {
    import ModifyFpgaImageAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse
      .builder()
      .optionallyWith(fpgaImageAttribute.map(value => value.buildAwsValue()))(
        _.fpgaImageAttribute
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly =
    zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.wrap(buildAwsValue())
}
object ModifyFpgaImageAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyFpgaImageAttributeResponse =
      zio.aws.ec2.model.ModifyFpgaImageAttributeResponse(
        fpgaImageAttribute.map(value => value.asEditable)
      )
    def fpgaImageAttribute
        : Optional[zio.aws.ec2.model.FpgaImageAttribute.ReadOnly]
    def getFpgaImageAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaImageAttribute.ReadOnly] =
      AwsError.unwrapOptionField("fpgaImageAttribute", fpgaImageAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse
  ) extends zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly {
    override val fpgaImageAttribute
        : Optional[zio.aws.ec2.model.FpgaImageAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fpgaImageAttribute())
        .map(value => zio.aws.ec2.model.FpgaImageAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse
  ): zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
