package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoadPermissionRequest(
    group: Optional[zio.aws.ec2.model.PermissionGroup] = Optional.Absent,
    userId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LoadPermissionRequest = {
    import LoadPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LoadPermissionRequest
      .builder()
      .optionallyWith(group.map(value => value.unwrap))(_.group)
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LoadPermissionRequest.ReadOnly =
    zio.aws.ec2.model.LoadPermissionRequest.wrap(buildAwsValue())
}
object LoadPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LoadPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LoadPermissionRequest =
      zio.aws.ec2.model.LoadPermissionRequest(
        group.map(value => value),
        userId.map(value => value)
      )
    def group: Optional[zio.aws.ec2.model.PermissionGroup]
    def userId: Optional[String]
    def getGroup: ZIO[Any, AwsError, zio.aws.ec2.model.PermissionGroup] =
      AwsError.unwrapOptionField("group", group)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LoadPermissionRequest
  ) extends zio.aws.ec2.model.LoadPermissionRequest.ReadOnly {
    override val group: Optional[zio.aws.ec2.model.PermissionGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.ec2.model.PermissionGroup.wrap(value))
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LoadPermissionRequest
  ): zio.aws.ec2.model.LoadPermissionRequest.ReadOnly = new Wrapper(impl)
}
