package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class ImageRecycleBinInfo(
    imageId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    recycleBinEnterTime: Optional[MillisecondDateTime] = Optional.Absent,
    recycleBinExitTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo = {
    import ImageRecycleBinInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
      .builder()
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        recycleBinEnterTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinEnterTime)
      .optionallyWith(
        recycleBinExitTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinExitTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly =
    zio.aws.ec2.model.ImageRecycleBinInfo.wrap(buildAwsValue())
}
object ImageRecycleBinInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImageRecycleBinInfo =
      zio.aws.ec2.model.ImageRecycleBinInfo(
        imageId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        recycleBinEnterTime.map(value => value),
        recycleBinExitTime.map(value => value)
      )
    def imageId: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def recycleBinEnterTime: Optional[MillisecondDateTime]
    def recycleBinExitTime: Optional[MillisecondDateTime]
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getRecycleBinEnterTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinEnterTime", recycleBinEnterTime)
    def getRecycleBinExitTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinExitTime", recycleBinExitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
  ) extends zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly {
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val recycleBinEnterTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recycleBinEnterTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val recycleBinExitTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recycleBinExitTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo
  ): zio.aws.ec2.model.ImageRecycleBinInfo.ReadOnly = new Wrapper(impl)
}
