package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.GpuDeviceMemorySize
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GpuDeviceMemoryInfo(
    sizeInMiB: Optional[GpuDeviceMemorySize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo = {
    import GpuDeviceMemoryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo
      .builder()
      .optionallyWith(
        sizeInMiB.map(value => GpuDeviceMemorySize.unwrap(value): Integer)
      )(_.sizeInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GpuDeviceMemoryInfo.ReadOnly =
    zio.aws.ec2.model.GpuDeviceMemoryInfo.wrap(buildAwsValue())
}
object GpuDeviceMemoryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GpuDeviceMemoryInfo =
      zio.aws.ec2.model.GpuDeviceMemoryInfo(sizeInMiB.map(value => value))
    def sizeInMiB: Optional[GpuDeviceMemorySize]
    def getSizeInMiB: ZIO[Any, AwsError, GpuDeviceMemorySize] =
      AwsError.unwrapOptionField("sizeInMiB", sizeInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo
  ) extends zio.aws.ec2.model.GpuDeviceMemoryInfo.ReadOnly {
    override val sizeInMiB: Optional[GpuDeviceMemorySize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMiB())
        .map(value => zio.aws.ec2.model.primitives.GpuDeviceMemorySize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GpuDeviceMemoryInfo
  ): zio.aws.ec2.model.GpuDeviceMemoryInfo.ReadOnly = new Wrapper(impl)
}
