package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSubnetCidrReservationsResponse(
    subnetIpv4CidrReservations: Optional[
      Iterable[zio.aws.ec2.model.SubnetCidrReservation]
    ] = Optional.Absent,
    subnetIpv6CidrReservations: Optional[
      Iterable[zio.aws.ec2.model.SubnetCidrReservation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse = {
    import GetSubnetCidrReservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse
      .builder()
      .optionallyWith(
        subnetIpv4CidrReservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetIpv4CidrReservations)
      .optionallyWith(
        subnetIpv6CidrReservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetIpv6CidrReservations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly =
    zio.aws.ec2.model.GetSubnetCidrReservationsResponse.wrap(buildAwsValue())
}
object GetSubnetCidrReservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSubnetCidrReservationsResponse =
      zio.aws.ec2.model.GetSubnetCidrReservationsResponse(
        subnetIpv4CidrReservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetIpv6CidrReservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def subnetIpv4CidrReservations
        : Optional[List[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly]]
    def subnetIpv6CidrReservations
        : Optional[List[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly]]
    def nextToken: Optional[String]
    def getSubnetIpv4CidrReservations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SubnetCidrReservation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "subnetIpv4CidrReservations",
      subnetIpv4CidrReservations
    )
    def getSubnetIpv6CidrReservations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SubnetCidrReservation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "subnetIpv6CidrReservations",
      subnetIpv6CidrReservations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse
  ) extends zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly {
    override val subnetIpv4CidrReservations
        : Optional[List[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIpv4CidrReservations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SubnetCidrReservation.wrap(item)
          }.toList
        )
    override val subnetIpv6CidrReservations
        : Optional[List[zio.aws.ec2.model.SubnetCidrReservation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetIpv6CidrReservations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SubnetCidrReservation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse
  ): zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
