package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{MillisecondDateTime, ImageId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EnableImageDeprecationRequest(
    imageId: ImageId,
    deprecateAt: MillisecondDateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest = {
    import EnableImageDeprecationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .deprecateAt(MillisecondDateTime.unwrap(deprecateAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableImageDeprecationRequest.ReadOnly =
    zio.aws.ec2.model.EnableImageDeprecationRequest.wrap(buildAwsValue())
}
object EnableImageDeprecationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableImageDeprecationRequest =
      zio.aws.ec2.model.EnableImageDeprecationRequest(imageId, deprecateAt)
    def imageId: ImageId
    def deprecateAt: MillisecondDateTime
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getDeprecateAt: ZIO[Any, Nothing, MillisecondDateTime] =
      ZIO.succeed(deprecateAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
  ) extends zio.aws.ec2.model.EnableImageDeprecationRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val deprecateAt: MillisecondDateTime =
      zio.aws.ec2.model.primitives.MillisecondDateTime(impl.deprecateAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest
  ): zio.aws.ec2.model.EnableImageDeprecationRequest.ReadOnly = new Wrapper(
    impl
  )
}
