package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiskImageVolumeDescription(
    id: Optional[String] = Optional.Absent,
    size: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription = {
    import DiskImageVolumeDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly =
    zio.aws.ec2.model.DiskImageVolumeDescription.wrap(buildAwsValue())
}
object DiskImageVolumeDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DiskImageVolumeDescription =
      zio.aws.ec2.model.DiskImageVolumeDescription(
        id.map(value => value),
        size.map(value => value)
      )
    def id: Optional[String]
    def size: Optional[Long]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription
  ) extends zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val size: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription
  ): zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly = new Wrapper(impl)
}
