package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeScheduledInstancesResponse(
    nextToken: Optional[String] = Optional.Absent,
    scheduledInstanceSet: Optional[
      Iterable[zio.aws.ec2.model.ScheduledInstance]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse = {
    import DescribeScheduledInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        scheduledInstanceSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledInstanceSet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeScheduledInstancesResponse.wrap(buildAwsValue())
}
object DescribeScheduledInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeScheduledInstancesResponse =
      zio.aws.ec2.model.DescribeScheduledInstancesResponse(
        nextToken.map(value => value),
        scheduledInstanceSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def scheduledInstanceSet
        : Optional[List[zio.aws.ec2.model.ScheduledInstance.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScheduledInstanceSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstance.ReadOnly
    ]] =
      AwsError.unwrapOptionField("scheduledInstanceSet", scheduledInstanceSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse
  ) extends zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val scheduledInstanceSet
        : Optional[List[zio.aws.ec2.model.ScheduledInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledInstanceSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ScheduledInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse
  ): zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
