package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcRequest(vpcId: VpcId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcRequest = {
    import DeleteVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpcRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcRequest.wrap(buildAwsValue())
}
object DeleteVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpcRequest =
      zio.aws.ec2.model.DeleteVpcRequest(vpcId)
    def vpcId: VpcId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
  ) extends zio.aws.ec2.model.DeleteVpcRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcRequest
  ): zio.aws.ec2.model.DeleteVpcRequest.ReadOnly = new Wrapper(impl)
}
